//
//  MCPopupController.h
//  MCApplication
//
//  Created by aj on Thu Nov 29 2001.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import <AppKit/AppKit.h>

@class MCAttribute;

@interface MCPopupController : NSObject {

	id				popup;			// not retained
	id				model;			// not retained
	id				list;			// not retained
	id				delegate;		// not retained
	id				displayField;	// not retained
	
	NSString		*nullSelectionString;
	NSString		*sortSelectorString;
	
	MCAttribute		*displayAttribute;
	MCAttribute		*associateAttribute;
	
	BOOL			_builtPopup;
	BOOL			_isHelper;
	
	BOOL			_modelIsList;
	
	
}

- (id)delegate;
- (void)setDelegate:(id)aDeleg;

// enables/disables the popup
- (void)setMutable:(BOOL)flag;
- (void)setEnabled:(BOOL)flag;

- (id)popup;

// textfield used to display the model list (using the displayAttribute thing)
- (id)displayField;


// Binder Proto conformance
- (void)setModel:aModel;
- (void)setModelNoUpdate:aModel;
- (id)model;

// If model is kind of MCTableviewController or MCBinder, this method returns the selected object or the binder's model
- (id)derivedModel;


// does nothign because we set values on target object as soon as the popup acts
- (void)updateModelFromInterface;

// builds the popup items based on the passed in list (array). Adds a null item at the top if allowsNullSelection is true. For each item, it invoke -displayValueForObject: to get the display string. The defaults implementation invokes the 'displayAction' on the iterated object. Finally if the targetObject returns something for 'associatedObjectAction' that item is selected. If the item is not in the list then an exception is raised
- (void)updateInterfaceFromModel;




- (void)clearPopupItems;

// List used to build the popup items
- (void)setSourceList:(id)aList;
- (id)sourceList;

// clears popup, sets list, updates interface
- (void)resetWithSourceList:(id)aList;
- (void)resetWithSourceList:(id)aList model:(id)aModel;

- (NSString *)displayAttributeName;
- (void)setDisplayAttributeName:(NSString *)aValue;
- (NSString *)associateObjectAttributeName;
- (void)setAssociateObjectAttributeName:(NSString *)aValue;
- (NSString *)nullSelectionString;
- (void)setNullSelectionString:(NSString *)aValue;
- (NSString *)sortSelectorString;
- (void)setSortSelectorString:(NSString *)aValue;

// If it's a helper then, no then model isn't told that an editor has changed it
- (BOOL)isHelper;
- (void)setIsHelper:(BOOL)flag;



- (BOOL)buildPopupFromList:(id)aList;



// invokes the 'displayAction' selector on object
- (id)displayValueForObject:(id)obj;

// invokes the associate selector, if the return value is not null, the popup item with the matching represented object is selected
- (void)selectMatchingPopupItem;


- (IBAction)popupActed:(id)sender;

@end

@interface NSObject (MCPopupControllerDelegate)

// gives the delegate the opportunity to add menu items - this is called before 'Edit ...' is constructed
- (void)popupController:(MCPopupController *)aCtl finishedBuildingPopup:(id)popButton;
- (void)popupControllerWantsListEdited:(MCPopupController *)aCtl;

- (BOOL)popupController:(MCPopupController *)aCtl 
		willSetMenuItem:(id)aMenuItem 
		representedObject:(id)anObj;
		
- (void)popupController:(MCPopupController *)aCtl 
		didSetMenuItem:(id)aMenuItem 
		representedObject:(id)anObj;		

- (void)popupController:(MCPopupController *)aCtl addedObject:(id)object toArray:(NSArray *)anArray;
- (void)popupController:(MCPopupController *)aCtl removedObject:(id)object fromArray:(NSArray *)anArray;

- (BOOL)popupControllerDelegateManagesObjectAddAndRemove:(MCPopupController *)aCtl;
- (void)popupController:(MCPopupController *)aCtl manageObjectAddition:(id)object;
- (void)popupController:(MCPopupController *)aCtl manageObjectRemoval:(id)object;

@end

